<?php

namespace Comitium5\ApiClientBundle\Tests\Stubs;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\Client\Client;

/**
 * Class ApiClientStub
 * @package Comitium5\ApiClientBundle\Tests\Stubs
 */
class ApiClientStub extends Client
{
    /**
     * @param $resourceType
     * @param $id
     * @return array|mixed
     */
    public function find($resourceType, $id)
    {
        if ($id === 999) {
            return [
                "statusCode" => 404,
                "data" => []
            ];
        }

        $extraData = [];

        if ($resourceType === ResourcesTypes::ASSET) {
            $extraData = [
                "src" => "/foo/bar.png"
            ];
        }

        if ($resourceType === ResourcesTypes::TAG) {
            $extraData = [
                "title" => "Tag title"
            ];
        }

        if ($resourceType === ResourcesTypes::CATEGORY) {
            $extraData = [
                "title" => "Category title"
            ];
        }

        if ($resourceType === ResourcesTypes::ARTICLE) {
            $extraData = [
                "title" => "Article title"
            ];
        }

        return [
            "statusCode" => 200,
            "data" => array_merge(
                [
                    "id" => $id,
                ],
                $extraData
            )
        ];
    }

    /**
     * @param $resourceType
     * @param array $parameters
     * @return array|mixed
     */
    public function findBy($resourceType, array $parameters = [])
    {
        return [
            "statusCode" => 200,
            "data" => [
                "results" => [
                    [
                        "id" => 1,
                    ],
                    [
                        "id" => 2,
                    ],
                    [
                        "id" => 3,
                    ],
                ]
            ]
        ];
    }


}