<?php

namespace Comitium5\ApiClientBundle\Client;

use GuzzleHttp\Client as GuzzleClient;

/**
 * Class Client
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\Client
 */
class Client extends RestClient implements ClientInterface
{
    /**
     * @param $site
     * @param $subSite
     * @param $locale
     * @param null $token
     * @return $this
     */
    public function buildClient(
        $site,
        $subSite,
        $locale,
        $token = null
    ) {

        $headers = [
            self::HEADER_AUTH     => sprintf("Bearer %s", $token !== null ? $token : $this->token),
            self::HEADER_SITE     => $site,
            self::HEADER_SUB_SITE => $subSite,
            self::HEADER_LANGUAGE => $locale,
        ];

        $this->client = new GuzzleClient([
            'base_uri' => $this->endPoint,
            'headers'  => $headers,
        ]);

        return $this;
    }


    /**
     * @param $resourceType
     * @param $id
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function find($resourceType, $id)
    {
        return $this->get(UrlResolver::resolveUrlPathByResourceType($resourceType, $id));
    }

    /**
     * @param $resourceType
     * @param array $parameters
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function findBy($resourceType, array $parameters = [])
    {
        return $this->get(
            UrlResolver::resolveUrlPathByResourceType($resourceType),
            $parameters
        );
    }

    /**
     * @param $resourceType
     * @param array $parameters
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function create($resourceType, array $parameters)
    {
        return $this->post(
            UrlResolver::resolveUrlPathByResourceType($resourceType),
            $parameters
        );
    }

    /**
     * @param $resourceType
     * @param $id
     * @param array $parameters
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function update($resourceType, $id, array $parameters)
    {
        return $this->put(
            UrlResolver::resolveUrlPathByResourceType($resourceType, $id),
            $parameters
        );
    }

    /**
     * @param $resourceType
     * @param $id
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function remove($resourceType, $id)
    {
        return $this->delete(
            UrlResolver::resolveUrlPathByResourceType($resourceType, $id)
        );
    }
}
