<?php

namespace Comitium5\ApiClientBundle\Normalizer;

use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class AssetApiNormalizer
 *
 * Normalizer for entities with asset (single) key
 *
 * @package Comitium5\ApiClientBundle\Normalizer
 */
class AssetApiNormalizer implements NormalizerInterface
{
    /**
     * @var AssetApiService
     */
    private $entityService;

    /**
     * AssetApiNormalizer constructor.
     * @param AssetApiService $entityService
     */
    public function __construct (AssetApiService $entityService)
    {
        $this->entityService = $entityService;
    }

    /**
     * @param array $entity
     *
     * @return array|mixed
     * @throws \Exception
     */
    public function normalize (array &$entity)
    {
        if (!empty($entity['asset']['id'])) {
            $entity['asset'] = $this->entity(new IdentifiedValue($entity['asset']['id']));
        }

        return $entity;
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    protected function entity (IdentifiedValue $identifiedValue)
    {
        return $this
            ->entityService
            ->find($identifiedValue);
    }
}