<?php

namespace Comitium5\ApiClientBundle\Tests\Normalizers;

use Comitium5\ApiClientBundle\Client\Services\ArticleApiService;
use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\Normalizer\ApiNormalizator;
use Comitium5\ApiClientBundle\Tests\Stubs\ApiClientStub;
use Comitium5\ApiClientBundle\Tests\TestCase;
use Comitium5\ApiClientBundle\Tests\Stubs\RelatedContentsApiNormalizerStub;


/**
 * Class RelatedContentApiNormalizerTest
 * @package Comitium5\ApiClientBundle\Tests\Normalizers
 */
class RelatedContentApiNormalizerTest extends TestCase
{
    /**
     * @test
     */
    public function normalizerFirst()
    {
        $entity = [
            "id" => 1,
            "relatedContent" => [
                [
                    "type" => "foo",
                    "id"   => 1,
                ],
                [
                    "type" => "articles",
                    "id"   => 1,
                ]
            ],
            "assets" => [
                ["id" => 1],
                ["id" => 2],
            ]
        ];

        $expectedEntity = [
            "id" => 1,
            "assets" => [
                ["id" => 1],
                ["id" => 2],
            ],
            "relatedContent" => [
                [
                    "type" => "foo",
                    "id"   => 1,
                ],
                [
                    "type" => "articles",
                    "id"   => 1,
                    "data" => [
                        "id" => 1,
                        "title" => "foo",
                    ]
                ]
            ],
        ];

        $normalizator = new ApiNormalizator([new RelatedContentsApiNormalizerStub($this->services())]);
        $normalized   = $normalizator->normalize($entity);

        $this->assertEquals($expectedEntity, $normalized);
    }

    /**
     * @return array
     */
    private function services()
    {
        return [
            "assets"   => new AssetApiService(new ApiClientStub("http://foo.com", "xxxx")),
            "articles" => new ArticleApiService(new ApiClientStub("http://foo.com", "xxxx")),
        ];
    }
}