<?php

namespace Comitium5\ApiClientBundle\Normalizer;

use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class AssetApiNormalizer
 *
 * Normalizer for entities with assets key
 *
 * @package Comitium5\ApiClientBundle\Normalizer
 */
class AssetsApiNormalizer implements NormalizerInterface
{
    /**
     * @var AssetApiService
     */
    private $entityService;

    /**
     * @var null|int
     */
    private $numberOfElements;

    /**
     * AssetsApiNormalizer constructor.
     * @param AssetApiService $entityService
     * @param null $numberOfElements
     */
    public function __construct (AssetApiService $entityService, $numberOfElements = null)
    {
        $this->entityService    = $entityService;
        $this->numberOfElements = $numberOfElements;
    }

    /**
     * @param array $entity
     *
     * @return array|mixed
     * @throws \Exception
     */
    public function normalize (array &$entity)
    {
        foreach ($entity['assets'] as $key => &$asset) {
            $asset = $this->entity(new IdentifiedValue($asset['id']));

            if ($this->numberOfElements !== null && ($key+1) >= $this->numberOfElements) {
                break;
            }
        }

        return $entity;
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    protected function entity (IdentifiedValue $identifiedValue)
    {
        return $this
            ->entityService
            ->find($identifiedValue);
    }
}