<?php

namespace Comitium5\ApiClientBundle\Cache;

/**
 * Interface CSMemoryCacheInterface
 *
 * Interface for all the wrappers of cache
 *
 * @author Oscar Jiménez <oscarjg19.developer@gmail.com>
 * @package ComitiumSuite\Bundle\CSCoreBundle\Cache
 */
interface MemoryCacheInterface
{
    /**
     * @access public
     *
     * @param string $key   he key name
     * @param mixed  $value value to save
     * @param int    $ttl   (optional) expiration
     * @param string $index (optional) index name
     *
     * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
     *
     * @return bool
     */
    public function set($key, $value, $ttl = null, $index = null);

    /**
     * Get a value from the cache
     *
     * @access public
     *
     * @param string $key   the key name
     * @param string $index (optional) if the key pertain to a index
     *
     * @return mixed|null
     */
    public function get($key, $index = null);

    /**
     * Delete a value from the cache
     *
     * @access public
     *
     * @param string $key   the key name
     * @param string $index (optional) if the key pertain to a index
     *
     * @return bool
     */
    public function delete($key, $index = null);

    /**
     * Set a expiration to a value
     *
     * @access public
     *
     * @param string $key the key name
     * @param int    $ttl the time in seconds to expire
     *
     * @return int|mixed
     */
    public function setTTL($key, $ttl);

    /**
     * Check if the object exists
     *
     * @access public
     *
     * @param string $key   the key name
     * @param string $index (optional) if the key pertain to a index
     *
     * @return int|mixed
     */
    public function exists($key, $index = null);
}
