<?php

namespace Comitium5\ApiClientBundle\Normalizer;

use Comitium5\ApiClientBundle\Client\Services\CategoryApiService;
use Comitium5\ApiClientBundle\Client\Services\TagApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class TagsApiNormalizer
 * @package Comitium5\ApiClientBundle\Normalizer
 */
class TagsApiNormalizer implements NormalizerInterface
{
    /**
     * @var CategoryApiService
     */
    private $entityService;

    /**
     * @var int|null
     */
    private $numberOfElements;

    /**
     * TagsApiNormalizer constructor.
     * @param TagApiService $entityService
     * @param null $numberOfElements
     */
    public function __construct (TagApiService $entityService, $numberOfElements = null)
    {
        $this->entityService    = $entityService;
        $this->numberOfElements = $numberOfElements;
    }

    /**
     * @param array $entity
     *
     * @return array|mixed
     * @throws \Exception
     */
    public function normalize (array &$entity)
    {
        foreach ($entity['tags'] as $key => &$tag) {
            $tag = $this->entity(new IdentifiedValue($tag['id']));

            if ($this->numberOfElements !== null && ($key+1) >= $this->numberOfElements) {
                break;
            }
        }

        return $entity;
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    protected function entity (IdentifiedValue $identifiedValue)
    {
        return $this
            ->entityService
            ->find($identifiedValue);
    }
}