<?php

namespace Comitium5\ApiClientBundle\Client;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;

/**
 * Class UrlResolver
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\Client
 */
final class UrlResolver
{
    /**
     * @param $resourceType
     * @return mixed
     */
    public static function resolveUrlPathByResourceType($resourceType, $id = null)
    {
        return self::fixUrlByResourceType($resourceType).DIRECTORY_SEPARATOR.$id;
    }

    /**
     * @param $resourceType
     * @return mixed
     */
    public static function fixUrlByResourceType($resourceType)
    {
        switch ($resourceType) {
            case ResourcesTypes::DIRECTORY_ITEM:
                $url = str_replace(".", DIRECTORY_SEPARATOR, ResourcesTypes::DIRECTORY_ITEM);
                break;
            default:
                $url = $resourceType;
                break;
        }

        return $url;
    }

    /**
     * Add final / if the url needs to fix it if:
     *      - Is not a get by id
     *      - Is not a page get by slug
     *      - Is not a url with with slash at the end
     * @param $url
     * @return string
     */
    public static function fixUrl($url)
    {
        preg_replace("/^\//", "", $url);

        if (
            preg_match("/\d+$/", $url) !== 1 &&
            preg_match("/pages\/[a-zA-Z0-9-_]+$/", $url) !== 1 &&
            preg_match("/tags\/[a-zA-Z0-9-_]+$/", $url) !== 1 &&
            preg_match("/categories\/[a-zA-Z0-9-_\/]+$/", $url) !== 1 &&
            preg_match("/\/$/", $url) !== 1
        ) {
            $url =  $url . DIRECTORY_SEPARATOR;
        }

        return $url;
    }
}