<?php

namespace Comitium5\ApiClientBundle\Tests\Stubs;

use Comitium5\ApiClientBundle\Client\Client;

/**
 * Class ApiClientStub
 * @package Comitium5\ApiClientBundle\Tests\Stubs
 */
class ApiClientStub extends Client
{
    /**
     * @param $resourceType
     * @param $id
     * @return array|mixed
     */
    public function find($resourceType, $id)
    {
        return [
            "statusCode" => 200,
            "data" => [
                "id" => $id,
            ]
        ];
    }

    /**
     * @param $resourceType
     * @param array $parameters
     * @return array|mixed
     */
    public function findBy($resourceType, array $parameters = [])
    {
        return [
            "statusCode" => 200,
            "data" => [
                "results" => [
                    [
                        "id" => 1,
                    ],
                    [
                        "id" => 2,
                    ],
                    [
                        "id" => 3,
                    ],
                ]
            ]
        ];
    }
}