<?php

namespace Comitium5\ApiClientBundle\Normalizer;

use Comitium5\ApiClientBundle\Client\Services\CategoryApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class CategoryApiNormalizer
 * @package Comitium5\ApiClientBundle\Normalizer
 */
class CategoryApiNormalizer implements NormalizerInterface
{
    /**
     * @var CategoryApiService
     */
    private $entityService;

    /**
     * @var int
     */
    private $indexToNormalize;

    /**
     * CategoryApiNormalizer constructor.
     * @param CategoryApiService $entityService
     * @param int $indexToNormalize
     */
    public function __construct (CategoryApiService $entityService, $indexToNormalize = 0)
    {
        $this->entityService    = $entityService;
        $this->indexToNormalize = $indexToNormalize;
    }

    /**
     * @param array $entity
     *
     * @return array|mixed
     * @throws \Exception
     */
    public function normalize (array &$entity)
    {
        if (!empty($entity['categories'][$this->indexToNormalize]["id"])) {
            $categoryId = $entity['categories'][$this->indexToNormalize]["id"];
            $entity['categories'][$this->indexToNormalize] = $this->entity(new IdentifiedValue($categoryId));
        }

        return $entity;
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    private function entity (IdentifiedValue $identifiedValue)
    {
        return $this
            ->entityService
            ->find($identifiedValue);
    }
}