<?php

namespace Comitium5\ApiClientBundle\Normalizer;

use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class AssetApiNormalizer
 *
 * Normalizer for entities with assets key
 *
 * @package Comitium5\ApiClientBundle\Normalizer
 */
class AssetsApiNormalizer implements NormalizerInterface
{
    /**
     * @var AssetApiService
     */
    private $entityService;

    /**
     * @var null|int
     */
    private $numberOfAssets;

    /**
     * AssetApiNormalizer constructor.
     * @param AssetApiService $entityService
     */
    public function __construct (AssetApiService $entityService, $numberOfAssets = null)
    {
        $this->entityService = $entityService;
        $this->numberOfAssets = $numberOfAssets;
    }

    /**
     * @param array $entity
     *
     * @return array|mixed
     * @throws \Exception
     */
    public function normalize (array &$entity)
    {
        if (!empty($entity['assets'])) {
            foreach ($entity['assets'] as $key => &$asset) {
                $asset = $this->entity(new IdentifiedValue($asset['id']));

                if ($this->numberOfAssets !== null && ($key+1) >= $this->numberOfAssets) {
                    break;
                }
            }
        }

        return $entity;
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    protected function entity (IdentifiedValue $identifiedValue)
    {
        return $this
            ->entityService
            ->find($identifiedValue);
    }
}