<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\Client\Client;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;

/**
 * Class AbstractApiService
 * @package Comitium5\ApiClientBundle\Client\Services
 */
abstract class AbstractApiService implements ApiServiceInterface
{
    /**
     * @var Client
     */
    protected $apiClient;

    /**
     * AbstractApiService constructor.
     * @param $apiClient
     */
    public function __construct(Client $apiClient)
    {
        $this->apiClient = $apiClient;
    }

    /**
     * @param array $response
     * @return array|mixed
     */
    protected function handleResponse(array $response)
    {
        return $response["statusCode"] === 200 ? $response["data"] : [];
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @param $type
     * @return array|mixed
     * @throws \Exception
     */
    protected function fetch(IdentifiedValue $identifiedValue, $type)
    {
        return $this
            ->apiClient
            ->find($type, $identifiedValue->getId());
    }

    /**
     * @param ParametersValue $parametersValue
     * @param $type
     * @return array|mixed
     * @throws \Exception
     */
    protected function fetchBy(ParametersValue $parametersValue, $type)
    {
        return $this
            ->apiClient
            ->findBy($type, $parametersValue->getOptions());
    }

    /**
     * @param ParametersValue $parametersValue
     * @param $type
     * @return array|mixed
     * @throws \Exception
     */
    protected function create(ParametersValue $parametersValue, $type)
    {
        return $this
            ->apiClient
            ->create($type, $parametersValue->getOptions());
    }

    /**
     * @param ParametersValue $parametersValue
     * @param $type
     * @return array|mixed
     * @throws \Exception
     */
    protected function update(IdentifiedValue $identifiedValue, ParametersValue $parametersValue, $type)
    {
        return $this
            ->apiClient
            ->update(
                $type,
                $identifiedValue->getId(),
                $parametersValue->getOptions()
            );
    }
}