<?php

namespace Comitium5\ApiClientBundle\ApiClient;

use GuzzleHttp\Client as GuzzleClient;

/**
 * Interface ClientInterface
 *
 * @deprecated
 * @author Oscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\ApiClient
 */
interface ClientInterface
{
    /**
     * @param null $endpoint
     * @param null $version
     * @param null $site
     * @param null $subSite
     * @return GuzzleClient
     */
    public function buildClient($endpoint = null, $version = null, $site = null, $subSite = null);

    /**
     * @param GuzzleClient $client
     * @return mixed
     */
    public function setClient(GuzzleClient $client);

    /**
     * @return GuzzleClient
     */
    public function getClient();

    /**
     * @param $endPoint
     * @return mixed
     */
    public function setEndPoint($endPoint);

    /**
     * @return mixed
     */
    public function getEndPoint();

    /**
     * @param $version
     * @return mixed
     */
    public function setVersion($version);

    /**
     * @return mixed
     */
    public function getVersion();

    /**
     * @param $site
     * @return mixed
     */
    public function setSite($site);

    /**
     * @return mixed
     */
    public function getSite();

    /**
     * @param $subSite
     * @return mixed
     */
    public function setSubSite($subSite);

    /**
     * @return mixed
     */
    public function getSubSite();

    /**
     * @return mixed
     */
    public function isCacheHeaders();

    /**
     * @return mixed
     */
    public function getCacheTTL();

    /**
     * @return mixed
     */
    public function isUseCache();

    /**
     * @param  array $cacheHeaders
     * @return mixed
     */
    public function setCacheHeaders(array $cacheHeaders);

    /**
     * @return mixed
     */
    public function getCacheHeaders();

    /**
     * @param $cacheTTL
     * @return mixed
     */
    public function setCacheTTL($cacheTTL);

    /**
     * @param $useCache
     * @return mixed
     */
    public function setUseCache($useCache);

    /**
     * @param $code
     *
     * @return mixed
     */
    public function setAcceptLanguage($code);

    /**
     * @param $forceGetContent
     * @return mixed
     */
    public function setForceGetContent($forceGetContent);

    /**
     * @param $method
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function call($method, $url, array $parameters = [], array $request_config = []);

    /**
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function get($url, array $parameters = [], array $request_config = []);

    /**
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function put($url, array $parameters = [], array $request_config = []);

    /**
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function post($url, array $parameters = [], array $request_config = []);

    /**
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function patch($url, array $parameters = [], array $request_config = []);

    /**
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function delete($url, array $parameters = [], array $request_config = []);
}
