<?php

namespace Comitium5\ApiClientBundle\Client;

/**
 * Class UrlResolver
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\Client
 */
final class UrlResolver
{
    /**
     * @param $resourceType
     * @return mixed
     */
    public static function resolveUrlPathByResourceType($resourceType, $id = null)
    {
        return self::fixUrlByResourceType($resourceType).DIRECTORY_SEPARATOR.$id;
    }

    /**
     * @param $resourceType
     * @return mixed
     */
    public static function fixUrlByResourceType($resourceType)
    {
        switch ($resourceType) {
            default:
                $url = $resourceType;
                break;
        }

        return $url;
    }

    /**
     * @param $url
     * @return string
     */
    public static function fixUrl($url)
    {
        preg_replace("/^\//", "", $url);

        if (preg_match("/\d+$/", $url) !== 1 && preg_match("/\/$/", $url) !== 1) {
            $url =  $url . DIRECTORY_SEPARATOR;
        }

        return $url;
    }
}