<?php

namespace Comitium5\ApiClientBundle\Tests\Provider;

use Comitium5\ApiClientBundle\Provider\ApiProvider;
use Comitium5\ApiClientBundle\Tests\TestCase;

/**
 * Class ApiProviderTest
 *
 * phpunit -c app src/Comitium5/ApiClientBundle/Tests/Provider/ApiProviderTest.php
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\Tests\Provider
 */
class ApiProviderTest extends TestCase
{
    /**
     * phpunit -c app --filter testFind src/Comitium5/ApiClientBundle/Tests/Provider/ApiProviderTest.php
     */
    public function testFind()
    {
        $client = $this->getClientMock();

        $response = $this->getResponseMock();

        $response
            ->expects($this->once())
            ->method("json")
            ->willReturn([
               "foo" => "bar",
            ]);

        $client
            ->expects($this->once())
            ->method('get')
            ->willReturn($response);

        $api = new ApiProvider($client);

        $this->assertEquals($api->find("foo", 1), ["foo" => "bar"]);
    }
}
