<?php

namespace Comitium5\ApiClientBundle\Generator;

class CSAuthenticationGenerator implements SignatureGeneratorInterface, TokenGeneratorInterface
{
    /**
     * @var string
     */
    private $publicKey;

    /**
     * @var string
     */
    private $privateKey;

    /**
     * @param $publicKey
     * @param $privateKey
     * @param string $algorithm
     */
    public function __construct($publicKey, $privateKey, $algorithm = 'sha256')
    {
        $this->publicKey  = $publicKey;
        $this->privateKey = $privateKey;
        $this->algorithm  = $algorithm;
    }

    /**
     * @param $raw
     * @param  string $salt
     * @return string
     */
    public function generateSignature($raw, $salt = '')
    {
        return hash_hmac(
            $this->algorithm,
            md5($raw).$salt.$this->publicKey,
            $this->privateKey);
    }

    /**
     * @param string $salt
     *
     * @return string
     */
    public function generateToken($salt = '')
    {
        return base64_encode(implode('|', array(
            'salt' => $salt,
            'publicKey' => $this->publicKey,
        )));
    }
}
