<?php

namespace Comitium5\ApiClientBundle\ApiClient;

/**
 * Interface ClientInterface
 *
 * @author Oscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\ApiClient
 */
interface ClientInterface
{
    /**
     * @return mixed
     */
    public function isCacheHeaders();

    /**
     * @return mixed
     */
    public function getCacheTTL();

    /**
     * @return mixed
     */
    public function isUseCache();

    /**
     * @param  array $cacheHeaders
     * @return mixed
     */
    public function setCacheHeaders(array $cacheHeaders);

    /**
     * @return mixed
     */
    public function getCacheHeaders();

    /**
     * @param $cacheTTL
     * @return mixed
     */
    public function setCacheTTL($cacheTTL);

    /**
     * @param $useCache
     * @return mixed
     */
    public function setUseCache($useCache);

    /**
     * @param $code
     *
     * @return mixed
     */
    public function setAcceptLanguage($code);

    /**
     * @param $forceGetContent
     * @return mixed
     */
    public function setForceGetContent($forceGetContent);

    /**
     * @param $method
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function call($method, $url, array $parameters = [], array $request_config = []);

    /**
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function get($url, array $parameters = [], array $request_config = []);

    /**
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function put($url, array $parameters = [], array $request_config = []);

    /**
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function post($url, array $parameters = [], array $request_config = []);

    /**
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function patch($url, array $parameters = [], array $request_config = []);

    /**
     * @param $url
     * @param  array                                 $parameters
     * @param  array                                 $request_config
     * @return \GuzzleHttp\Message\ResponseInterface
     */
    public function delete($url, array $parameters = [], array $request_config = []);
}
