<?php

namespace Comitium5\ApiClientBundle\Tests;

/**
 * Class TestCase
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\Tests\Abstracts
 */
class TestCase extends \PHPUnit_Framework_TestCase
{
    /**
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    protected function getClientMock()
    {
        return $this->getMock(
            'Comitium5\ApiClientBundle\ApiClient\Client',
            [],
            [
                "http://www.test.com",
                [
                    "version" => "v1",
                    "site" => "site",
                    "subsite" => "subsite",
                ],
                true,
                -1
            ]
        );
    }

    /**
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    protected function getResponseMock()
    {
        return $this->getMock(
            'GuzzleHttp\Message\Response',
            ['json'],
            [
                200,
                [
                    'Content-Type' => 'application/json'
                ]
            ]
        );
    }
}
