<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;

/**
 * Class SubsiteApiService
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\ApiClientBundle\Client\Services
 */
class SubsiteApiService extends AbstractApiService
{
    /**
     * @param IdentifiedValue $identifiedValue
     *
     * @return array
     * @throws \Exception
     */
    public function find(IdentifiedValue $identifiedValue): array
    {
        $response = $this->fetch(
            $identifiedValue,
            ResourcesTypes::SUBSITE
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     *
     * @return array
     * @throws \Exception
     */
    public function findBy(ParametersValue $parametersValue): array
    {
        $response = $this->fetchBy(
            $parametersValue,
            ResourcesTypes::SUBSITE
        );

        return $this->handleResponse($response);
    }
}
