<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class GalleryApiService
 * @package Comitium5\ApiClientBundle\Client\Services
 */
class GalleryApiService extends AbstractApiService
{
    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    public function find(IdentifiedValue $identifiedValue)
    {
        $response = $this->fetch(
            $identifiedValue,
            ResourcesTypes::GALLERY
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     * @return array
     * @throws \Exception
     */
    public function findBy(ParametersValue $parametersValue)
    {
        $response = $this->fetchBy(
            $parametersValue,
            ResourcesTypes::GALLERY
        );

        return $this->handleResponse($response);
    }
}