<?php

namespace Client;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\Client\UrlResolver;
use PHPUnit\Framework\TestCase;

class UrlResolverTest extends TestCase
{
    public function testFixUrlByResourceTypeWithDirectoryItem()
    {
        $result = UrlResolver::fixUrlByResourceType(ResourcesTypes::DIRECTORY_ITEM);

        $this->assertEquals('directories/items', $result);
    }

    public function testFixUrlByResourceTypeWithDirectoryItemPublic()
    {
        $result = UrlResolver::fixUrlByResourceType(ResourcesTypes::DIRECTORY_ITEM_PUBLIC);

        $this->assertEquals('directories/items', $result);
    }

    public function testFixUrlByResourceTypeWithOtherValue()
    {
        $otherValue = 'some_random_resource';
        $result = UrlResolver::fixUrlByResourceType($otherValue);

        $this->assertEquals($otherValue, $result);
    }
}
