<?php

namespace Comitium5\ApiClientBundle\Normalizer;

use Comitium5\ApiClientBundle\Client\Services\AbstractApiService;
use Comitium5\ApiClientBundle\Client\Services\CategoryApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class RelatedContentsApiNormalizer
 *
 * @deprecated in favor of RelatedContentsMultiSubSiteApiNormalizer
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\ApiClientBundle\Normalizer
 */
class RelatedContentsApiNormalizer implements NormalizerInterface
{
    /**
     * @var CategoryApiService
     */
    private $entityServices;

    /**
     * RelatedContentsApiNormalizer constructor.
     * @desc An array key => value on key is the resource type and value the api service
     *
     * @param array $entityServices
     */
    public function __construct(array $entityServices)
    {
        $this->entityServices = $entityServices;
    }

    /**
     * @param array $entity
     *
     * @return array|mixed
     * @throws \Exception
     */
    public function normalize(array &$entity)
    {
        $normalizedRelatedContent = [];

        if (!empty($entity['relatedContent'])) {
            foreach ($entity['relatedContent'] as $key => &$relatedContent) {
                $type = $relatedContent["type"];
                $id = $relatedContent['id'];

                if (isset($this->entityServices[$type])) {
                    $fetchedEntity = $this->entity(
                        $this->entityServices[$type],
                        new IdentifiedValue($id)
                    );

                    if (empty($fetchedEntity)) {
                        unset($entity['relatedContent'][$key]);

                        continue;
                    }

                    $relatedContent["data"] = $fetchedEntity;

                    $normalizedRelatedContent[] = $relatedContent;
                }
            }
        }

        $entity['relatedContent'] = $normalizedRelatedContent;

        return $entity;
    }

    /**
     * @param IdentifiedValue $identifiedValue
     *
     * @return array|mixed
     * @throws \Exception
     */
    protected function entity(
        AbstractApiService $apiService,
        IdentifiedValue $identifiedValue
    ) {
        return $apiService->find($identifiedValue);
    }
}