<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Exception;

/**
 * Class MenuApiService
 *
 * @package Comitium5\ApiClientBundle\Client\Services
 */
class MenuApiService extends AbstractApiService
{
    /**
     * @param IdentifiedValue $identifiedValue
     *
     * @return array
     * @throws Exception
     */
    public function find(IdentifiedValue $identifiedValue): array
    {
        $response = $this->fetch(
            $identifiedValue,
            "menus"
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     *
     * @return array
     * @throws Exception
     */
    public function findBy(ParametersValue $parametersValue): array
    {
        $response = $this->fetchBy(
            $parametersValue,
            "menus"
        );

        return $this->handleResponse($response);
    }
}