<?php

namespace Comitium5\ApiClientBundle\Provider;

use Comitium5\ApiClientBundle\Parser\ResponseParser;
use Psr\Http\Message\ResponseInterface;

/**
 * Class ResponseDecorator
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\Provider
 */
class ResponseDecorator
{
    /**
     * @var ResponseInterface
     */
    protected $response;

    /**
     * ResponseDecorator constructor.
     * @param ResponseInterface $response
     */
    public function __construct(ResponseInterface $response)
    {
        $this->response = $response;
    }

    /**
     * @return array
     */
    public function json()
    {
        return ResponseParser::decodeResponse($this->response);
    }

    /**
     * @return int
     */
    public function getStatusCode()
    {
        return $this
            ->response
            ->getStatusCode();
    }

    /**
     * @param $name
     * @return string
     */
    public function getHeaderLine($name)
    {
        return $this
            ->response
            ->getHeaderLine($name);
    }

    /**
     * @return \Psr\Http\Message\StreamInterface
     */
    public function getBody()
    {
        return $this
            ->response
            ->getBody();
    }
}