<?php

namespace Comitium5\ApiClientBundle\Factory;

use Comitium5\ApiClientBundle\Client\Client;

/**
 * Class ClientFactory
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Factory
 */
class ClientFactory
{
    /**
     * @var string
     */
    protected $endPoint;

    /**
     * @var string
     */
    protected $token;

    /**
     * ClientFactory constructor.
     *
     * @param $endPoint
     * @param $token
     */
    public function __construct($endPoint, $token)
    {
        $this->endPoint = $endPoint;
        $this->token    = $token;
    }

    /**
     * @param $siteAcronym
     * @param $subSiteAcronym
     * @param $locale
     *
     * @return Client
     */
    public function createInstance(
        $siteAcronym,
        $subSiteAcronym,
        $locale
    ) {
        return (new Client(
            $this->endPoint,
            $this->token
        ))->buildClient($siteAcronym, $subSiteAcronym, $locale);
    }
}
