<?php

namespace BabHttpClient;

/**
 * Class AccountsClient
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package BabHttpClient
 */
class AccountsClient extends AbstractClient
{
    /**
     * @param $apiToken
     *
     * @return mixed|\Psr\Http\Message\ResponseInterface
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function auth($apiToken)
    {
        return $this
            ->client
            ->request('GET', '/api/v1/auth/', [
                'headers' => [
                    'Authorization' => 'Bearer ' . $apiToken,
                    'Content-Type'  => 'application/json',
                ]
            ]);
    }

    /**
     * @param $clientPublic
     * @param $clientPrivate
     *
     * @return mixed|\Psr\Http\Message\ResponseInterface
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function requestToken($clientPublic, $clientPrivate)
    {
        return $this
            ->client
            ->request('GET', '/oauth/v2/token', [
                'headers' => [
                    'Content-Type'  => 'application/json',
                ],
                'query' => [
                    'client_id'     => $clientPublic,
                    'client_secret' => $clientPrivate,
                    'grant_type'    => 'client_credentials'
                ]
            ]);
    }
}