<?php

namespace BabHttpClient;

/**
 * Class DistributionClient
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package BabHttpClient
 */
class DistributionClient extends AbstractClient
{
    /**
     * @param $apiToken
     * @param array $body
     *
     * @return mixed|\Psr\Http\Message\ResponseInterface
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function rabbit($apiToken, array $body)
    {
        return $this
            ->client
            ->request('POST','/api/v1/rabbit/producer', [
                'headers' => [
                    'Authorization' => 'Bearer ' . $apiToken,
                ],
                "form_params" => $body
            ]);
    }
}